/********************************************************************************/
/*	File : giet_config.h                                                        */
/*	Author : Alain Greiner                                                      */
/*	Date : 26/03/2013                                                           */
/********************************************************************************/
/* 	Define various configuration parameters for the GIET			            */
/********************************************************************************/

#ifndef _GIET_CONFIG_H
#define _GIET_CONFIG_H

/* hardware parameters */
#include "hard_config.h"

/* Debug parameters */

#define BOOT_DEBUG_MAPPING       0			/* trace map_info checking */
#define BOOT_DEBUG_PT		     0			/* trace page tables initialisation */
#define BOOT_DEBUG_VOBJS	     0			/* trace vobjs initialisation */
#define BOOT_DEBUG_PERI          0			/* trace peripherals initialisation */
#define BOOT_DEBUG_SCHED 	     0			/* trace schedulers initialisation */

#define GIET_DEBUG_INIT		     0			/* trace parallel kernel initialisation */
#define GIET_DEBUG_SWITCH	     0			/* trace context switchs  */
#define GIET_DEBUG_IOC_DRIVER    0          /* trace IOC accesses */
#define GIET_DEBUG_DMA_DRIVER    0          /* trace DMA accesses */

#define CONFIG_SRL_VERBOSITY TRACE 

/* software parameters */

#define GIET_NB_VSPACE_MAX	     64			/* max number of virtual spaces */
#define GIET_TICK_VALUE	         0x100000	/* context switch period (number of cycles) */
#define GIET_USE_IOMMU           0          /* IOMMU activated when non zero */
#endif

