#include <stdio.h>

#define NBLOCKS 32   // number of blocks per image (128 * 128) / 512

unsigned char buf0[128*128] __attribute__((aligned(64)));
unsigned char buf1[128*128] __attribute__((aligned(64)));

__attribute__((constructor)) int main(void)
{
    unsigned int  x;
    unsigned int  base = 0;

    /* initialise CDMA transfert (double buffer) */

    giet_tty_printf( "*** Starting task DISPLAY_CMA on processor %d at cycle %d\n",
                     giet_procid(), giet_proctime() );
    giet_tty_printf( "  - buf0 address (LSB) = %x\n", (unsigned int)buf0 );
    giet_tty_printf( "  - buf1 address (LSB) = %x\n", (unsigned int)buf1 );

    x = giet_fb_cma_init( buf0,       // buf0 base address
                          buf1,       // buf1 base address
                          128*128 );  // buffer size (bytes)
    giet_assert( (x==0), "echec giet_fb_cdma_init" );

    while (base < 10 * NBLOCKS)
    {
        /* Phase 1 : transfer one image from disk to buf0 and display  */

        giet_tty_printf( "\n *** image %d *** at date = %d \n",
                         (base/NBLOCKS), giet_proctime() );

        x = giet_ioc_read( base,            // lba on disk
                           buf0,            // user buffer address
                           NBLOCKS );       // number of blocks
        giet_assert( (x==0) , "echec giet_ioc_read for buf0" );

        x = giet_ioc_completed();
        giet_assert( (x==0) , "echec giet_ioc_completed for buf0" );

        giet_tty_printf( "ioc_read buf0 completed at date = %d \n", giet_proctime() );

        x = giet_fb_cma_write( 0 );         // buf0
        giet_assert( (x==0) , "echec giet_fb_cma_write for buf0" );
        
        base = base + NBLOCKS;

        /* Phase 2 : transfer one image from disk to buf1 and display  */

        giet_tty_printf( "\n *** image %d *** at date = %d \n",
                         (base/NBLOCKS), giet_proctime() );

        x = giet_ioc_read( base,            // lba on disk
                           buf1,            // user buffer address
                           NBLOCKS );       // number of locks
        giet_assert( (x==0) , "echec giet_ioc_read for buf1");

        x = giet_ioc_completed();
        giet_assert( (x==0) , "echec giet_ioc_completed for buf1");

        giet_tty_printf( "ioc_read buf1 completed at date = %d \n", giet_proctime() );

        x = giet_fb_cma_write( 1 );         // buf1
        giet_assert( (x==0) , "echec giet_fb_cma_write for buf1" );
        
        base = base + NBLOCKS;
    } // end while

    giet_fb_cma_stop();
    giet_exit();
    return 0;
}
