///////////////////////////////////////////////////////////////////////////////////
// File     : fbf_driver.h
// Date     : 01/11/2013
// Author   : alain greiner
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////

#ifndef _GIET_FBF_DRIVERS_H_
#define _GIET_FBF_DRIVERS_H_

///////////////////////////////////////////////////////////////////////////////////
// Frame Buffer access functions  (vci_frame_buffer)
///////////////////////////////////////////////////////////////////////////////////

extern unsigned int _fb_sync_write( unsigned int offset, 
                                    const void * buffer, 
                                    unsigned int length );

extern unsigned int _fb_sync_read(  unsigned int offset, 
                                    void *       buffer, 
                                    unsigned int length );

extern unsigned int _fb_cma_init( const void*  vbase0,
                                  const void*  vbase1,
                                  unsigned int length );

extern unsigned int _fb_cma_write( unsigned int buffer_id );

extern unsigned int _fb_cma_stop();

///////////////////////////////////////////////////////////////////////////////////


#endif

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

