///////////////////////////////////////////////////////////////////////////////////
// File     : iob_driver.c
// Date     : 23/05/2013
// Author   : alain greiner
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////
// The iob_driver.c and iob_driver.h files are part ot the GIET-VM kernel.
// This driver supports the TSAR vci_io_bridge, that is a bridge to access
// The external peripherals, implementing an IO_MMU.
///////////////////////////////////////////////////////////////////////////////////
// The seg_iob_base virtual base addresses must be defined in giet_vsegs.ld file.
///////////////////////////////////////////////////////////////////////////////////

#include <giet_config.h>
#include <iob_driver.h>
#include <utils.h>

#if !defined(GIET_USE_IOMMU) 
# error: You must define GIET_USE_IOMMU in the giet_config.h file
#endif

#if !defined( USE_IOB )
# error: You must define USE_IOB in the hard_config.h file
#endif

///////////////////////////////////////////////////////////////////////////////
//      _iob_inval_tlb_entry()
// This function invalidates a TLB entry identified by a virtual address.
// Returns 0 if success, returns 1 if failure
///////////////////////////////////////////////////////////////////////////////
unsigned int _iob_inval_tlb_entry( unsigned int vaddr )
{
#if USE_IOB

    unsigned int * iob_address = (unsigned int *) &seg_iob_base ;
    iob_address[IOB_INVAL_PTE] = vaddr;
    return 0; 

#else

    return 1;

#endif
}


// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

