///////////////////////////////////////////////////////////////////////////////////
// File     : mwr_driver.h
// Date     : 01/11/2013
// Author   : alain greiner
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////

#ifndef _GIET_MWR_DRIVERS_H_
#define _GIET_MWR_DRIVERS_H_

///////////////////////////////////////////////////////////////////////////////////
// MWMR controler registers offsets 
///////////////////////////////////////////////////////////////////////////////////

enum SoclibMwmrRegisters 
{
    MWMR_IOREG_MAX = 16,
    MWMR_RESET = MWMR_IOREG_MAX,
    MWMR_CONFIG_FIFO_WAY,
    MWMR_CONFIG_FIFO_NO,
    MWMR_CONFIG_STATUS_ADDR,
    MWMR_CONFIG_DEPTH,
    MWMR_CONFIG_BUFFER_ADDR,
    MWMR_CONFIG_RUNNING,
    MWMR_CONFIG_WIDTH,
    MWMR_FIFO_FILL_STATUS,
};

enum SoclibMwmrWay 
{
    MWMR_TO_COPROC,
    MWMR_FROM_COPROC,
};

///////////////////////////////////////////////////////////////////////////////////
// MWMR controller access functions
///////////////////////////////////////////////////////////////////////////////////

extern unsigned int _mwmr_hw_init( unsigned int           cluster_id, 
                                   unsigned int           port_id, 
                                   unsigned int           from_coproc,
                                   unsigned long long     channel_pbase);

///////////////////////////////////////////////////////////////////////////////////


#endif

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

