///////////////////////////////////////////////////////////////////////////////////
// File     : tim_driver.h
// Date     : 01/11/2013
// Author   : alain greiner 
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////

#ifndef _GIET_TIM_DRIVERS_H_
#define _GIET_TIM_DRIVERS_H_

///////////////////////////////////////////////////////////////////////////////////
// TIMER (vci_multi_timer) registers offsets
///////////////////////////////////////////////////////////////////////////////////

enum TIMER_registers 
{
    TIMER_VALUE     = 0,
    TIMER_MODE      = 1,
    TIMER_PERIOD    = 2,
    TIMER_RESETIRQ  = 3,
    /**/
    TIMER_SPAN      = 4,
};

///////////////////////////////////////////////////////////////////////////////////
// Timer access functions and global variables
///////////////////////////////////////////////////////////////////////////////////

extern volatile unsigned char _timer_event[];

extern unsigned int _timer_start( unsigned int cluster_id, 
                                  unsigned int local_id, 
                                  unsigned int period );

extern unsigned int _timer_stop( unsigned int cluster_id,
                                 unsigned int local_id );

extern unsigned int _timer_reset_irq( unsigned int cluster_id, 
                                      unsigned int local_id );

extern unsigned int _timer_reset_cpt( unsigned int cluster_id, 
                                      unsigned int local_id);

///////////////////////////////////////////////////////////////////////////////////

#endif

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

