///////////////////////////////////////////////////////////////////////////////////
// File     : cma_driver.h
// Date     : 01/11/2013
// Author   : alain greiner
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////

#ifndef _GIET_CMA_DRIVERS_H_
#define _GIET_CMA_DRIVERS_H_

///////////////////////////////////////////////////////////////////////////////////
// CMA (vci_chbuf_dma) registers offsets
///////////////////////////////////////////////////////////////////////////////////

enum CMA_registers 
{
    CHBUF_RUN           = 0,    // write-only : channel activated
    CHBUF_STATUS        = 1,    // read-only  : channel fsm state
    CHBUF_SRC_DESC      = 2,    // read/write : source chbuf : descriptor base address
    CHBUF_DST_DESC      = 3,    // read/write : destination chbuf : descriptor base address,
    CHBUF_SRC_NBUFS     = 4,    // read/write : source chbuf : number of buffers,
    CHBUF_DST_NBUFS     = 5,    // read/write : destination chbuf : number of buffers,
    CHBUF_BUF_SIZE      = 6,    // read/write : buffer size for both source & destination  
    CHBUF_PERIOD        = 7,    // read/write : period for status polling 
    CHBUF_SRC_EXT       = 8,    // read/write : source chbuf : descriptor base address
    CHBUF_DST_EXT       = 9,    // read/write : destination chbuf : descriptor base address,
    /****/
    CHBUF_CHANNEL_SPAN	= 1024,
};

#endif

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

