///////////////////////////////////////////////////////////////////////////////////
// File     : iob_driver.h
// Date     : 01/11/2013
// Author   : alain greiner
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////

#ifndef _GIET_IOB_DRIVER_H_
#define _GIET_IOB_DRIVER_H_

///////////////////////////////////////////////////////////////////////////////////
// TSAR IOB (vci_io_bridge) registers offsets
///////////////////////////////////////////////////////////////////////////////////

enum IOB_registers 
{
    IOB_IOMMU_PTPR       = 0, /* R/W : Page Table Pointer Register */
    IOB_IOMMU_ACTIVE     = 1, /* R/W : IOMMU activated if not 0 */
    IOB_IOMMU_BVAR       = 2, /* R   : Bad Virtual Address (unmapped) */
    IOB_IOMMU_ETR        = 3, /* R   : Error Type */
    IOB_IOMMU_BAD_ID     = 4, /* R   : Faulty Peripheral Index */
    IOB_INVAL_PTE        = 5, /* W   : Invalidate a PTE (virtual address) */
    IOB_IT_ADDR_IOMMU_LO = 6, /* W/R : 32 LSB bits for IOMMU IT*/
    IOB_IT_ADDR_IOMMU_HI = 7, /* W/R : 32 MSB bits for IOMMU IT */
    IOB_IT_ADDRESS_BEGIN = 8, /* R/W : Peripheral IT address (2 32 bits registers) */
};

///////////////////////////////////////////////////////////////////////////////////
// TSAR IOB access functions
///////////////////////////////////////////////////////////////////////////////////

extern unsigned int _iob_inval_tlb_entry( unsigned int vaddr );

extern unsigned int _iob_set_iommu_ptpr( unsigned int value );

///////////////////////////////////////////////////////////////////////////////////

#endif

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

