#ifndef _IRQ_HANDLER_H
#define _IRQ_HANDLER_H

enum isr_type_t
{
    ISR_DEFAULT = 0,
    ISR_SWITCH  = 1,
    ISR_TTY     = 2,
    ISR_DMA     = 3,
    ISR_IOC     = 4,
    ISR_TIMER   = 5,
    ISR_WAKUP   = 6,
};


///////////////////////////////////////////////////////////////////////////////
// Prototypes of the Interrupt Service Routines (ISRs) supported by the GIET.
///////////////////////////////////////////////////////////////////////////////

extern void _irq_demux();

extern void _isr_default();
extern void _isr_ioc();
extern void _isr_timer(unsigned int channel);
extern void _isr_dma(unsigned int channel);
extern void _isr_tty(unsigned int channel);
extern void _isr_switch();
extern void _isr_wakup();

#endif

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

