///////////////////////////////////////////////////////////////////////////////////
// File     : mwr_driver.c
// Date     : 23/05/2013
// Author   : alain greiner
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////
// The mwmr_driver.c and mwmr_driver.h files are part ot the GIET-VM nano-kernel.
// This driver supports the SoClib vci_mwmr_controller component.
// 
// This peripheral can be replicated (at most one component per cluster).
///////////////////////////////////////////////////////////////////////////////////
// The (virtual) base address of the associated segment is:
//
//       seg_mwr_base + cluster_id * vseg_cluster_increment
//
// The seg_mwr_base and vseg_cluster_increment values must be defined 
// in the giet_vsegs.ld file.
////////////////////////////////////////////////////////////////////////////////

#include <giet_config.h>
#include <mwr_driver.h>
#include <utils.h>

#if !defined(NB_CLUSTERS) 
# error: You must define NB_CLUSTERS in the hard_config.h file
#endif

#if (NB_CLUSTERS > 256)
# error: NB_CLUSTERS cannot be larger than 256!
#endif

//////////////////////////////////////////////////////////////////////////////////
//    _mwmr_hw_init()
// This function initializes one MWMR controller channel (i.e. one coprocessor
// port) in a given cluster.
// - cluster_id    : cluster index
// _ port_id       : port index
// - way           : direction (to_coproc/from_coproc)
// - channel_pbase : physical base address of the MWMR channel 
// TODO : The MWMR controler should be modified to support 40 bits addresses...
//        Introduce a MWMR_CONFIG_PADDR_EXT register in the MWMR coprocessor
//        To support addresses > 32 bits and remove this limitation...
//////////////////////////////////////////////////////////////////////////////////
// Returns 0 if success, returns > 0 if error.
//////////////////////////////////////////////////////////////////////////////////
unsigned int _mwmr_hw_init( unsigned int           cluster_id, 
                            unsigned int           port_id, 
                            unsigned int           from_coproc,
                            paddr_t                channel_pbase ) 
{
    _puts(" [GIET_ERROR] _mwmr_hw_init() function not implemented yet\n");
    _exit();

/*
    // parameters checking 
    if (cluster_id >= NB_CLUSTERS)      return 1;

    // compute MWMR base address
    unsigned int* mwmr_address = (unsigned int*) ((unsigned int)&seg_mwmr_base + 
                                 (cluster_id * (unsigned int)&vseg_cluster_increment));

    unsigned int lsb = (unsigned int)channel_pbase;
    unsigned int msb = (unsigned int)(channel_pbase>>32);

    // get depth and width from channel itself
    unsigned int depth = _physical_read( channel_pbase + 16 );
    unsigned int width = _physical_read( channel_pbase + 20 );

    // initializes and launches mwmr controler
    mwmr_address[port_id * MWMR_SPAN + MWMR_CONFIG_FIFO_WAY]  = from_coproc;
    mwmr_address[port_id * MWMR_SPAN + MWMR_CONFIG_FIFO_NO]   = port_id;
    mwmr_address[port_id * MWMR_SPAN + MWMR_CONFIG_WIDTH]     = width;
    mwmr_address[port_id * MWMR_SPAN + MWMR_CONFIG_DEPTH]     = depth;
    mwmr_address[port_id * MWMR_SPAN + MWMR_CONFIG_STATUS]    = lsb;
    mwmr_address[port_id * MWMR_SPAN + MWMR_CONFIG_DATA]      = lsb + 24;
    mwmr_address[port_id * MWMR_SPAN + MWMR_CONFIG_EXT]       = msb;
    mwmr_address[port_id * MWMR_SPAN + MWMR_CONFIG_RUNNING]   = 1;
*/
    return 0;
}


// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

