///////////////////////////////////////////////////////////////////////////////////
// File     : dma_driver.h
// Date     : 01/11/2013
// Author   : alain greiner
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////

#ifndef _GIET_DMA_DRIVER_H_
#define _GIET_DMA_DRIVER_H_

///////////////////////////////////////////////////////////////////////////////////
// Multi DMA registers offset
///////////////////////////////////////////////////////////////////////////////////

enum DMA_registers 
{
    DMA_SRC         = 0,
    DMA_DST         = 1,
    DMA_LEN         = 2,
    DMA_RESET       = 3,
    DMA_IRQ_DISABLE = 4,
    DMA_SRC_EXT     = 5,
    DMA_DST_EXT     = 6,
    /**/
    DMA_END         = 7,
    DMA_SPAN        = 8,
};

enum SoclibDmaStatus 
{
    DMA_SUCCESS      = 0,
    DMA_READ_ERROR   = 1,
    DMA_IDLE         = 2,
    DMA_WRITE_ERROR  = 3,
    DMA_BUSY         = 4,
};


///////////////////////////////////////////////////////////////////////////////////
// Multi DMA variables and access functions  (vci_multi_dma)
///////////////////////////////////////////////////////////////////////////////////

// low level access functions
extern unsigned int _dma_init( unsigned int cluster_xy,
                               unsigned int channel_id );

extern unsigned int _dma_reset( unsigned int  cluster_xy, 
                                unsigned int  channel_id );

extern unsigned int _dma_get_status( unsigned int  cluster_xy, 
                                     unsigned int  channel_id );

extern unsigned int _dma_start_transfer( unsigned int       cluster_xy,
                                         unsigned int       channel_id,
                                         unsigned long long dst_paddr,
                                         unsigned long long src_paddr,
                                         unsigned int       size );

// higher level access function
extern void _dma_copy(  unsigned int vspace_id,
                        void*        dest,
                        const void*  source,
                        unsigned int size ); 

///////////////////////////////////////////////////////////////////////////////////

#endif

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

