///////////////////////////////////////////////////////////////////////////////////
// File     : ioc_driver.h
// Date     : 01/11/2013
// Author   : alain greiner
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////

#ifndef _GIET_IOC_DRIVERS_H_
#define _GIET_IOC_DRIVERS_H_

///////////////////////////////////////////////////////////////////////////////////
// IOC (vci_block device) registers offsets
///////////////////////////////////////////////////////////////////////////////////

enum IOC_registers 
{
    BLOCK_DEVICE_BUFFER,
    BLOCK_DEVICE_LBA,
    BLOCK_DEVICE_COUNT,
    BLOCK_DEVICE_OP,
    BLOCK_DEVICE_STATUS,
    BLOCK_DEVICE_IRQ_ENABLE,
    BLOCK_DEVICE_SIZE,
    BLOCK_DEVICE_BLOCK_SIZE,
    BLOCK_DEVICE_BUFFER_EXT,
};
enum IOC_operations 
{
    BLOCK_DEVICE_NOOP,
    BLOCK_DEVICE_READ,
    BLOCK_DEVICE_WRITE,
};
enum IOC_status
{
    BLOCK_DEVICE_IDLE,
    BLOCK_DEVICE_BUSY,
    BLOCK_DEVICE_READ_SUCCESS,
    BLOCK_DEVICE_WRITE_SUCCESS,
    BLOCK_DEVICE_READ_ERROR,
    BLOCK_DEVICE_WRITE_ERROR,
    BLOCK_DEVICE_ERROR,
};
enum IOC_driver_modes
{
    IOC_BOOT_PA_MODE,  // No V2P translation / Polling IOC_STATUS / no access checking
    IOC_BOOT_VA_MODE,  // V2P translation    / Polling IOC_STATUS / no access checking
    IOC_KERNEL_MODE,   // V2P translation    / Descheduling + IRQ / no access checking
    IOC_USER_MODE,     // V2P translation    / Descheduling + IRQ / access checking
};

///////////////////////////////////////////////////////////////////////////////////
// IOC access functions and variables (vci_block_device)
///////////////////////////////////////////////////////////////////////////////////

extern unsigned int          _ioc_lock;
extern volatile unsigned int _ioc_status;
extern volatile unsigned int _ioc_gtid;
extern volatile unsigned int _ioc_iommu_ix1;
extern volatile unsigned int _ioc_iommu_npages; 

extern unsigned int _ioc_init();

extern unsigned int _ioc_write( unsigned int mode,
                                unsigned int lba, 
                                const void*  buffer, 
                                unsigned int count );

extern unsigned int _ioc_read(  unsigned int mode,
                                unsigned int lba, 
                                void*        buffer,
                                unsigned int count );

extern unsigned int _ioc_get_status( unsigned int  channel,
                                     unsigned int* status );

extern unsigned int _ioc_get_block_size();

///////////////////////////////////////////////////////////////////////////////////


#endif

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

