///////////////////////////////////////////////////////////////////////////////////
// File     : xcu_driver.h
// Date     : 01/11/2013
// Author   : alain greiner
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////

#ifndef _GIET_XCU_DRIVER_H_
#define _GIET_XCU_DRIVER_H_

///////////////////////////////////////////////////////////////////////////////////
// XICU registers offsets
///////////////////////////////////////////////////////////////////////////////////

enum Xicu_registers 
{
    XICU_WTI_REG = 0,
    XICU_PTI_PER = 1,
    XICU_PTI_VAL = 2,
    XICU_PTI_ACK = 3,

    XICU_MSK_PTI = 4,
    XICU_MSK_PTI_ENABLE = 5,
    XICU_MSK_PTI_DISABLE = 6,
    XICU_PTI_ACTIVE = 6,

    XICU_MSK_HWI = 8,
    XICU_MSK_HWI_ENABLE = 9,
    XICU_MSK_HWI_DISABLE = 10,
    XICU_HWI_ACTIVE = 10,

    XICU_MSK_WTI = 12,
    XICU_MSK_WTI_ENABLE = 13,
    XICU_MSK_WTI_DISABLE = 14,
    XICU_WTI_ACTIVE = 14,

    XICU_PRIO = 15,
};

#define XICU_REG(func, index) (((func)<<5)|(index))
 
///////////////////////////////////////////////////////////////////////////////////
// XICU access functions 
///////////////////////////////////////////////////////////////////////////////////

extern unsigned int _xcu_get_index( unsigned int cluster_xy, 
                                    unsigned int irq_index, 
                                    unsigned int * buffer );

extern unsigned int _xcu_set_mask( unsigned int cluster_xy,
                                   unsigned int irq_index,
                                   unsigned int mask, 
                                   unsigned int is_timer );

extern unsigned int _xcu_send_ipi( unsigned int cluster_xy,
                                   unsigned int wti_index,
                                   unsigned int wdata );

extern unsigned int _xcu_timer_start( unsigned int cluster_xy, 
                                      unsigned int pti_index,
                                      unsigned int period ); 

extern unsigned int _xcu_timer_stop( unsigned int cluster_xy, 
                                     unsigned int pti_index ); 

extern unsigned int _xcu_timer_reset_irq( unsigned int cluster_xy, 
                                          unsigned int pti_index );

extern unsigned int _xcu_timer_reset_cpt( unsigned int cluster_xy, 
                                          unsigned int pti_index ); 

///////////////////////////////////////////////////////////////////////////////////

#endif

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

