///////////////////////////////////////////////////////////////////////////////////
// File     : icu_driver.h
// Date     : 01/11/2013
// Author   : alain greiner
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////

#ifndef _GIET_ICU_DRIVER_H_
#define _GIET_ICU_DRIVER_H_

///////////////////////////////////////////////////////////////////////////////////
// ICU registers offsets
///////////////////////////////////////////////////////////////////////////////////

enum ICU_registers 
{
    ICU_INT         = 0,
    ICU_MASK        = 1,
    ICU_MASK_SET    = 2,
    ICU_MASK_CLEAR  = 3,
    ICU_IT_VECTOR   = 4,
    /**/
    ICU_END         = 5,
    ICU_SPAN        = 8,
};

///////////////////////////////////////////////////////////////////////////////////
// ICU and XICU access functions 
///////////////////////////////////////////////////////////////////////////////////

extern unsigned int _icu_get_index( unsigned int cluster_xy, 
                                    unsigned int proc_id, 
                                    unsigned int * buffer );

extern unsigned int _icu_set_mask( unsigned int cluster_xy,
                                   unsigned int proc_id,
                                   unsigned int value );

///////////////////////////////////////////////////////////////////////////////////

#endif

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

