#ifndef _CTX_HANDLER_H
#define _CTX_HANDLER_H

#include <giet_config.h>

/////////////////////////////////////////////////////////////////////////////////
//    Definition of the scheduler structure
/////////////////////////////////////////////////////////////////////////////////

typedef struct static_scheduler_s 
{
    unsigned int context[15][64];      // at most 15 task contexts
    unsigned int tasks;                // actual number of tasks
    unsigned int current;              // current task index
    unsigned int interrupt_vector[32]; // interrupt vector
} static_scheduler_t;


/////////////////////////////////////////////////////////////////////////////////
//  "idle" task index definition
/////////////////////////////////////////////////////////////////////////////////

#define IDLE_TASK_INDEX        14

/////////////////////////////////////////////////////////////////////////////////
//    Definition of the task context slots indexes
/////////////////////////////////////////////////////////////////////////////////

#define CTX_SP_ID        29
#define CTX_RA_ID        31

#define CTX_EPC_ID       32  // Exception Program Counter (CP0)
#define CTX_CR_ID        33  // Cause Register (CP0)
#define CTX_SR_ID        34  // Status Register (CP0)
#define CTX_BVAR_ID      35	 // Bad Virtual Address Register (CP0)

#define CTX_PTAB_ID      36  // Page Table Virtual address
#define CTX_LTID_ID      37  // Local  Task Index (in scheduler)
#define CTX_VSID_ID      38  // Vspace Index     
#define CTX_PTPR_ID      39  // Page Table Pointer Register (PADDR>>13)

#define CTX_TTY_ID       40  // global TTY terminal  
#define CTX_DMA_ID       41  // local DMA channel 
#define CTX_NIC_ID       42  // global NIC channel 
#define CTX_TIM_ID       43  // local TIMER channel
#define CTX_HBA_ID       44  // global HBA channel
#define CTX_CMA_ID       45  // global CMA channel 
#define CTX_GTID_ID      46  // Global Task Index
#define CTX_RUN_ID       47  // Boolean: task runable
#define CTX_TRDID_ID     48  // Thread Index in vspace

//////////////////////////////////////////////////////////////////////////////////
//     Prototype of the context switch function
//////////////////////////////////////////////////////////////////////////////////

extern void _ctx_switch();
extern void _ctx_eret();
extern void _idle_task();

extern static_scheduler_t _scheduler[];

#endif
