///////////////////////////////////////////////////////////////////////////////////
// File     : tty_driver.h
// Date     : 01/11/2013
// Author   : alain greiner
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////

#ifndef _GIET_TTY_DRIVERS_H_
#define _GIET_TTY_DRIVERS_H_

///////////////////////////////////////////////////////////////////////////////////
// TTY (vci_multi_tty) registers offsets
///////////////////////////////////////////////////////////////////////////////////

enum TTY_registers 
{
    TTY_WRITE   = 0,
    TTY_STATUS  = 1,
    TTY_READ    = 2,
    TTY_CONFIG  = 3,
    /**/
    TTY_SPAN    = 4,
};

///////////////////////////////////////////////////////////////////////////////////
// TTY access functions and variables
///////////////////////////////////////////////////////////////////////////////////

extern volatile unsigned char _tty_get_buf[];

extern volatile unsigned char _tty_get_full[];

/////// rather high level access functions ///////////////////////////////////////

extern unsigned int _tty_write( const char*  buffer,
                                unsigned int length,     // number of characters 
                                unsigned int channel );  // channel index

extern unsigned int _tty_read(  char*        buffer,
                                unsigned int length,     // unused
                                unsigned int channel );  // channel index

/////// very low level access functions //////////////////////////////////////////

extern void _tty_write_data( unsigned int channel, char byte );

extern unsigned int _tty_read_data( unsigned int channel );

extern unsigned int _tty_get_status( unsigned int channel );

extern void _tty_get_lock( unsigned int channel );

extern void _tty_release_lock( unsigned int channel );

///////////////////////////////////////////////////////////////////////////////////


#endif

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

