///////////////////////////////////////////////////////////////////////////////////
// File     : sys_handler.h
// Date     : 01/04/2012
// Author   : alain greiner and joel porquet
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////

#ifndef _SYS_HANDLER_H
#define _SYS_HANDLER_H

//////////////////////////////////////////////////////////////////////////////////
//     Syscall Vector Table (indexed by syscall index)
//////////////////////////////////////////////////////////////////////////////////

extern const void * _syscall_vector[64];

//////////////////////////////////////////////////////////////////////////////////
// Prototypes os the syscall handlers (other than peripheral drivers)
//////////////////////////////////////////////////////////////////////////////////

void         _sys_ukn();
void         _task_exit();
void         _context_switch();
unsigned int _local_task_id();
unsigned int _global_task_id();
unsigned int _thread_id();

int          _tty_get_release_lock(unsigned int val);

unsigned int _procs_number( unsigned int  cluster_id, 
                            unsigned int* number );

unsigned int _vobj_get_vbase( char*         vspace_name, 
                              char*         vobj_name, 
                              unsigned      vobj_type, 
                              unsigned int* vobj_buffer);

#endif

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

