///////////////////////////////////////////////////////////////////////////////////
// File      : bdv_driver.h
// Date      : 01/11/2013
// Author    : alain greiner
// Maintainer: cesar fuguet
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////

#ifndef _GIET_BDV_DRIVERS_H_
#define _GIET_BDV_DRIVERS_H_

#include <mapping_info.h>

///////////////////////////////////////////////////////////////////////////////////
// BDV access functions and variables (vci_block_device)
///////////////////////////////////////////////////////////////////////////////////

extern unsigned int _bdv_init( unsigned int channel );

extern unsigned int _bdv_write( unsigned int mode,
                                unsigned int lba, 
                                paddr_t      buffer, 
                                unsigned int count );

extern unsigned int _bdv_read(  unsigned int mode,
                                unsigned int lba, 
                                paddr_t      buffer,
                                unsigned int count );

extern unsigned int _bdv_get_status( unsigned int  channel,
                                     unsigned int* status );

extern unsigned int _bdv_get_block_size();

///////////////////////////////////////////////////////////////////////////////////

#endif

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

