#include "stdio.h"
#include "hard_config.h"

#define NBLOCKS 32   // (128 * 128) / 512

unsigned char buf[128*128] __attribute__((aligned(512)));

__attribute__((constructor)) void main()
{  
    int             fd;
    int             blocks;
    unsigned int    ko;
    unsigned int    blocks_to_skip = 8*NBLOCKS;

    unsigned int    procid     = giet_procid();
    unsigned int    cluster_xy = procid/NB_PROCS_MAX;
    unsigned int    lpid       = procid%NB_PROCS_MAX;
    unsigned int    x          = cluster_xy >> Y_WIDTH;
    unsigned int    y          = cluster_xy & ((1<<Y_WIDTH)-1);

    giet_tty_printf( "*** Starting task display on processor[%d,%d,%d] at cycle %d\n\n", 
                      x, y, lpid, giet_proctime() );

    ///////////////////////////////////////////
    fd = giet_fat_open( "misc/images.raw", 0 );
    if ( fd < 0 )
    {
        giet_tty_printf("\n*** echec giet_fat_open for misc/images.raw at cycle %d\n", 
                        giet_proctime() );
        giet_exit();
    }
    else
    {
        giet_tty_printf("\ngiet_fat_open completed for misc/images.raw at cycle %d\n", 
                        giet_proctime() );
    }

    /////////////////////////////////////////
    while ( blocks_to_skip < (10 * NBLOCKS) )
    {
        // lecture image sur le disque
        blocks = giet_fat_read( fd, buf, NBLOCKS, blocks_to_skip );
        if ( blocks != NBLOCKS )
        {
            giet_tty_printf("\n*** echec giet_fat_read at cycle %d\n", 
                            giet_proctime() );
            giet_exit();
        }
        else
        {
            giet_tty_printf("\ngiet_fat_read for image %d completed at cycle %d \n", 
                            (blocks_to_skip>>5), giet_proctime());
        }

        // transfert vers le frame buffer  
        ko = giet_fb_sync_write( 0, buf, 128 * 128 );
        if ( ko )
        {
            giet_tty_printf("\n*** echec giet_fb_sync_write at cycle %d\n", 
                            giet_proctime() );
            giet_exit();
        }
        else
        {
            giet_tty_printf("\ndisplay completed for image %d at cycle %d \n", 
                            (blocks_to_skip>>5), giet_proctime());
        }

        blocks_to_skip = blocks_to_skip + NBLOCKS;
    }

    giet_tty_printf("\n*** Tak display exit at cycle %d ***\n", giet_proctime());
    giet_exit();
}
