#include "stdio.h"
#include "hard_config.h"

#define NBLOCKS 32

unsigned char buf0[128*128] __attribute__((aligned(512)));
unsigned char buf1[128*128] __attribute__((aligned(512)));

__attribute__((constructor)) void main(void)
{
    int             fd;
    unsigned int    blocks_to_skip = 0;
    unsigned int    procid         = giet_procid();
    unsigned int    cluster_xy     = procid/NB_PROCS_MAX;
    unsigned int    lpid           = procid%NB_PROCS_MAX;
    unsigned int    x              = cluster_xy >> Y_WIDTH;
    unsigned int    y              = cluster_xy & ((1<<Y_WIDTH)-1);

    giet_tty_printf( "*** Starting task display on processor[%d,%d,%d] at cycle %d\n\n", 
                      x, y, lpid, giet_proctime() );

    //////////////////////////////////////////
    fd = giet_fat_open( "misc/images.raw", 0 );
    if ( fd < 0 )
    {
        giet_tty_printf("\n*** echec giet_fat_open for misc/images.raw at cycle %d\n", 
                        giet_proctime() );
        giet_exit();
    }
    else
    {
        giet_tty_printf("\ngiet_fat_open completed for misc/images.raw at cycle %d\n", 
                        giet_proctime() );
    }

    ////////////////////////////////////////
    giet_fb_cma_init( buf0, buf1, 128*128 );

    giet_tty_printf("\ngiet_cma_init completed at cycle %d\n", 
                        giet_proctime() );
 
    while ( blocks_to_skip < 10 * NBLOCKS )
    {
        ///////////////////////////////////////////////////
        giet_fat_read( fd, buf0, NBLOCKS, blocks_to_skip );

        giet_tty_printf("\ngiet_fat_read to buf0 completed at cycle = %d\n",
                            giet_proctime() );

        ///////////////////////
        giet_fb_cma_write( 0 );

        giet_tty_printf("giet_cma_write for buf0 completed at cycle = %d\n",
                            giet_proctime() );

        blocks_to_skip = blocks_to_skip + NBLOCKS;

        ///////////////////////////////////////////////////
        giet_fat_read( fd, buf1, NBLOCKS, blocks_to_skip );

        giet_tty_printf("giet_fat_read to buf1 completed at cycle = %d\n",
                            giet_proctime() );

        ///////////////////////
        giet_fb_cma_write( 1 );
        
        giet_tty_printf("giet_cma_write for buf1 completed at cycle = %d\n",
                            giet_proctime() );

        blocks_to_skip = blocks_to_skip + NBLOCKS;
    }

    ///////////////////
    giet_fb_cma_stop();

    giet_tty_printf("\n*** Task display exit at cycle %d ***\n", giet_proctime());

    giet_exit();
}
