///////////////////////////////////////////////////////////////////////////////////
// File     : ioc_driver.h
// Date     : 01/11/2013
// Author   : alain greiner
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////

#ifndef _GIET_IOC_DRIVER_H_
#define _GIET_IOC_DRIVER_H_

///////////////////////////////////////////////////////////////////////////////////
// IOC (vci_block device) registers offsets
///////////////////////////////////////////////////////////////////////////////////

enum IOC_driver_modes
{
    IOC_BOOT_MODE   = 0,     //  Polling IOC_STATUS / no access right checking
    IOC_KERNEL_MODE = 1,     //  Descheduling + IRQ / no access right checking
    IOC_USER_MODE   = 2,     //  Descheduling + IRQ / access right checking
};

///////////////////////////////////////////////////////////////////////////////////
// IOC global variables (generic disk controller)
///////////////////////////////////////////////////////////////////////////////////

extern volatile unsigned int _ioc_iommu_ix1;
extern volatile unsigned int _ioc_iommu_npages; 

///////////////////////////////////////////////////////////////////////////////////
// IOC access functions  (generic disk controller)
///////////////////////////////////////////////////////////////////////////////////

extern unsigned int _ioc_init( unsigned int channel );

extern unsigned int _ioc_write( unsigned int channel,
                                unsigned int mode,
                                unsigned int lba, 
                                const void*  buffer, 
                                unsigned int count );

extern unsigned int _ioc_read(  unsigned int channel,
                                unsigned int mode,
                                unsigned int lba, 
                                void*        buffer,
                                unsigned int count );

extern unsigned int _ioc_get_status( unsigned int channel );

extern unsigned int _ioc_get_block_size();

///////////////////////////////////////////////////////////////////////////////////


#endif

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

