//////////////////////////////////////////////////////////////////////////////////
// File     : barrier.h         
// Date     : 01/04/2012
// Author   : alain greiner
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////

#ifndef _BARRIER_H_
#define _BARRIER_H_

///////////////////////////////////////////////////////////////////////////////////
//  barrier structure
///////////////////////////////////////////////////////////////////////////////////

typedef struct giet_barrier_s 
{
    char name[32];      // barrier name
    unsigned int init;  // total number of participants
    unsigned int count; // number of not yet arrived tasks
} giet_barrier_t;

//////////////////////////////////////////////////////////////////////////////
//  access functions
//////////////////////////////////////////////////////////////////////////////

void barrier_init( giet_barrier_t* barrier,
                   unsigned int    value );  // number of tasks  

void barrier_wait( giet_barrier_t* barrier );

#endif

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

