///////////////////////////////////////////////////////////////////////////////////
// File      : bdv_driver.h
// Date      : 01/11/2013
// Author    : alain greiner
// Maintainer: cesar fuguet
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////

#ifndef _GIET_BDV_DRIVER_H_
#define _GIET_BDV_DRIVER_H_

///////////////////////////////////////////////////////////////////////////////////
// BDV global variables
///////////////////////////////////////////////////////////////////////////////////

extern unsigned int          _bdv_lock;    // BDV is a shared ressource
extern volatile unsigned int _bdv_status;  // required for IRQ signaling
extern volatile unsigned int _bdv_gtid;    // descheduled task id = gpid<<16 + ltid

///////////////////////////////////////////////////////////////////////////////////
// BDV registers, operations and status values
///////////////////////////////////////////////////////////////////////////////////

enum BDV_registers 
{
    BLOCK_DEVICE_BUFFER,
    BLOCK_DEVICE_LBA,
    BLOCK_DEVICE_COUNT,
    BLOCK_DEVICE_OP,
    BLOCK_DEVICE_STATUS,
    BLOCK_DEVICE_IRQ_ENABLE,
    BLOCK_DEVICE_SIZE,
    BLOCK_DEVICE_BLOCK_SIZE,
    BLOCK_DEVICE_BUFFER_EXT,
};

enum BDV_operations 
{
    BLOCK_DEVICE_NOOP,
    BLOCK_DEVICE_READ,
    BLOCK_DEVICE_WRITE,
};

enum BDV_status
{
    BLOCK_DEVICE_IDLE,
    BLOCK_DEVICE_BUSY,
    BLOCK_DEVICE_READ_SUCCESS,
    BLOCK_DEVICE_WRITE_SUCCESS,
    BLOCK_DEVICE_READ_ERROR,
    BLOCK_DEVICE_WRITE_ERROR,
    BLOCK_DEVICE_ERROR,
};

///////////////////////////////////////////////////////////////////////////////////
// BDV access functions (vci_block_device)
///////////////////////////////////////////////////////////////////////////////////

extern unsigned int _bdv_init();

extern unsigned int _bdv_write( unsigned int       mode,
                                unsigned int       lba, 
                                unsigned long long buffer, 
                                unsigned int       count );

extern unsigned int _bdv_read(  unsigned int       mode,
                                unsigned int       lba, 
                                unsigned long long buffer,
                                unsigned int       count );

extern unsigned int _bdv_get_status();

extern unsigned int _bdv_get_block_size();

extern void _bdv_isr( unsigned irq_type,
                      unsigned irq_id,
                      unsigned channel );

///////////////////////////////////////////////////////////////////////////////////

#endif

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

