///////////////////////////////////////////////////////////////////////////////////
// File     : irq_handler.h
// Date     : 01/04/2012
// Author   : alain greiner 
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////
// The irq_handler.c and irq_handler.h files are part of the GIET-VM nano-kernel.
// They contain the code of the _irq_demux() function that access the XICU or
// ICU component (Interupt Controler Unit), and the various ISRs (Interrupt
// Service Routine) associated to the various ISR types.
///////////////////////////////////////////////////////////////////////////////////

#ifndef _IRQ_HANDLER_H
#define _IRQ_HANDLER_H

////////////////////////////////////////////////////////////////////////////////
// This enum must be kept consistent with the values defined in the
// xml_driver.c and irq_handler.c files (for display)
///////////////////////////////////////////////////////////////////////////////

enum isr_type_t
{
    ISR_DEFAULT = 0,
    ISR_TICK    = 1,
    ISR_TTY_RX  = 2,
    ISR_TTY_TX  = 3,
    ISR_BDV     = 4,
    ISR_TIMER   = 5,
    ISR_WAKUP   = 6,
    ISR_NIC_RX  = 7,
    ISR_NIC_TX  = 8,
    ISR_CMA     = 9,
    ISR_MMC     = 10,
};

///////////////////////////////////////////////////////////////////////////////
// Prototypes of the Interrupt Service Routines (ISRs) supported by the GIET.
///////////////////////////////////////////////////////////////////////////////

extern void _irq_demux();

extern void _isr_default();

extern void _isr_tick( unsigned int irq_type,
                       unsigned int irq_id,
                       unsigned int channel );

extern void _isr_wakup( unsigned int irq_type,
                        unsigned int irq_id,
                        unsigned int channel );

#endif

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

