///////////////////////////////////////////////////////////////////////////////////
// File      : cma_driver.c
// Date      : 01/03/2014
// Author    : alain greiner
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////
// The cma_driver.c and cma_driver.h files are part ot the GIET-VM kernel.
// This driver supports the SocLib vci_chbuf_dma component, that is
// a multi channels, chained buffer DMA controller.
//
// This component can be used in conjonction with the SocLib vci_frame_buffer 
// to display images, or with the SocLib vci_multi_nic controller to tranfer
// both RX and TX packets between NIC and memory buffers.
///////////////////////////////////////////////////////////////////////////////////
// Implementation notes:
// 1. The higher level access functions can be found in the fbf_driver and 
//    nic_driver files.
// 2. All accesses to CMA registers are done by the two
//    _cma_set_register() and _cma_get_register() low-level functions,
//    that are handling virtual / physical extended addressing.
///////////////////////////////////////////////////////////////////////////////////

#include <cma_driver.h>
#include <utils.h>                  // for seg_cma_base
#include <hard_config.h>            // for X_IO / Y_IO

///////////////////////////////////////////////////////////////////////////////
// This low_level function returns the value contained in register (index).
///////////////////////////////////////////////////////////////////////////////
unsigned int _cma_get_register( unsigned int channel,
                                unsigned int index )
{
    unsigned int* vaddr = (unsigned int*)&seg_cma_base + 
                           CHBUF_CHANNEL_SPAN*channel + index;
    return _io_extended_read( vaddr );
}

///////////////////////////////////////////////////////////////////////////////
// This low-level function set a new value in register (index).
///////////////////////////////////////////////////////////////////////////////
void _cma_set_register( unsigned int channel,
                        unsigned int index,
                        unsigned int value ) 
{
    unsigned int* vaddr = (unsigned int*)&seg_cma_base + 
                           CHBUF_CHANNEL_SPAN*channel + index;
    _io_extended_write( vaddr, value );
}

///////////////////////////////////////////////////////////////////////////////
// This ISR handles the IRQ generated by a CMA channel.
///////////////////////////////////////////////////////////////////////////////
void _cma_isr( unsigned int irq_type,
               unsigned int irq_id,
               unsigned int channel )
{
    _printf("\n[GIET ERROR] _cma_isr() nor implemented\n");
    _exit();
}

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

