///////////////////////////////////////////////////////////////////////////////////
// File     : pic_driver.c
// Date     : 05/03/2014
// Author   : alain greiner
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////
// The pic_driver.c and pic_drivers.h files are part ot the GIET-VM kernel.
// This driver supports the SocLib vci_iopic component.
//
// The seg_pic_base address must be defined in giet_vsegs.ld file.
///////////////////////////////////////////////////////////////////////////////////
// Implementation note:
// 
// All physical accesses to device registers are done by the two
// _pic_get_register(), _pic_set_register() low-level functions,
// that are handling virtual / physical addressing.
///////////////////////////////////////////////////////////////////////////////////

#include <pic_driver.h>
#include <utils.h>

/////////////////////////////////////////////////////////////////////////////////
// This low level function returns the value of register (channel / index)
/////////////////////////////////////////////////////////////////////////////////
unsigned int _pic_get_register( unsigned int channel,
                                unsigned int index )
{
    unsigned int* vaddr = (unsigned int*)&seg_pic_base + channel*IOPIC_SPAN + index;
    return _io_extended_read( vaddr );
}

/////////////////////////////////////////////////////////////////////////////////
// This low level function set a new value in register (channel / index)  
/////////////////////////////////////////////////////////////////////////////////
void _pic_set_register( unsigned int channel,
                        unsigned int index,
                        unsigned int value )
{
    unsigned int* vaddr = (unsigned int*)&seg_pic_base + channel*IOPIC_SPAN + index;
    _io_extended_write( vaddr, value );
}

/////////////////////////////////////////////////////////////////////////////////
// This function initializes the XICU target physical address corresponding
// to a given HWI channel.
/////////////////////////////////////////////////////////////////////////////////
void _pic_init( unsigned int channel,      // source PIC HWI channel
                unsigned int vaddr,        // dest XCU WTI address
                unsigned int extend )      // dest XCU cluster_xy
{
    _pic_set_register( channel, IOPIC_ADDRESS, vaddr );
    _pic_set_register( channel, IOPIC_EXTEND, extend );
}

/////////////////////////////////////////////////////////////////////////////////
// This function returns the status of a given HWI channel.
/////////////////////////////////////////////////////////////////////////////////
unsigned int _pic_get_status( unsigned int channel )
{
    return _pic_get_register( channel, IOPIC_STATUS );
}


// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

