///////////////////////////////////////////////////////////////////////////////////
// File     : pic_driver.h
// Date     : 05/03/2014
// Author   : alain greiner
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////

#ifndef _GIET_PIC_DRIVERS_H_
#define _GIET_PIC_DRIVERS_H_

///////////////////////////////////////////////////////////////////////////////////
// PIC (vci_iopic) registers offsets
///////////////////////////////////////////////////////////////////////////////////

enum PIC_registers 
{
    IOPIC_ADDRESS = 0,
    IOPIC_EXTEND  = 1,
    IOPIC_STATUS  = 2,
    /**/
    IOPIC_SPAN    = 4,
};

//////////////////////////////////////////////////////////////////////////////////
// PIC access functions
//////////////////////////////////////////////////////////////////////////////////

extern void _pic_init( unsigned int channel,     // source PIC HWI channel
                       unsigned int vaddr,       // dest XCU WTI address
                       unsigned int extend );    // dest XCU cluster_xy

extern unsigned int _pic_get_status( unsigned int channel ); 

///////////////////////////////////////////////////////////////////////////////////
// low-level access functions
///////////////////////////////////////////////////////////////////////////////////

extern unsigned int _pic_get_register( unsigned int channel,
                                       unsigned int index );

extern void _pic_set_register( unsigned int channel,
                               unsigned int index,
                               unsigned int value );

#endif

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

