#!/usr/bin/env python

from tsar_generic_leti import *
from transpose import *
from sort import *

#######################################################################################
#   file   : tsar_generic_iob_transpose.py
#   date   : april 2014
#   author : Alain Greiner
#######################################################################################
# This generic script maps one or several applications on a specific instance
# of the tsar_generic_leti platform.
# The platform mandatory parameters to be defined are:
#  - x_size    : number of clusters in a row
#  - y_size    : number of clusters in a column
#  - nb_procs  : number of processors per cluster
#######################################################################################

# define target platform parameters

x_size   = 4
y_size   = 4
nb_procs = 4

# build empty mapping (no application)

mapping = tsar_generic_leti( x_size, y_size, nb_procs )

# complete mapping with application(s)

appli = transpose( mapping )
mapping.addVspace( appli )
mapping.name += '_transpose'

#appli = sort( mapping )
#mapping.addVspace( appli )
#mapping.name += '_sort'

# save xml file

path = '/Users/alain/soc/giet_vm/mappings/' + mapping.name + '.xml'
f = open ( path, 'w' )
f.write( str( mapping ) )


