#################################################################################
#	File : reset.s
#	Author : Alain Greiner
#	Date : 15/09/2010
#################################################################################
# 	This is an improved boot code supporting IOC and DMA peripherals : 
#	- It initializes the Status Register (SR) 
#	- It defines the stack sizes  and initializes the stack pointers ($29) 
#	- It initializes the interrupt vector with 4 ISR addresses
#	  (tty, timer,dma,block-device), and initialises the ICU.
#	- It initializes the EPC register, and jumps to the main in user mode.
#################################################################################
		
	.section .reset,"ax",@progbits

	.extern	seg_stack_base
	.extern	seg_icu_base
	.extern	_interrupt_vector
	.extern _isr_tty_get_task0
	.extern _isr_timer
	.extern _isr_dma
	.extern _isr_ioc
	.extern	main

	.globl  reset	 			# makes reset an external symbol 
	.ent	reset
	.align	2

reset:
       	.set noreorder

# initializes stack pointers
	la	$29,	seg_stack_base 		
	li	$26,	0x40000
	addu	$29,	$29,	$26		# stack size = 256 Kbytes

# initializes interrupt vector
        la      $26,    _interrupt_vector       # interrupt vector address
        la      $27,    _isr_timer              #
        sw      $27,    0($26)                  # interrupt_vector[0] <= _isr_timer
        la      $27,    _isr_tty_get_task0      # 
        sw      $27,    4($26)                  # interrupt_vector[1] <= _isr_tty_get_task0
        la      $27,    _isr_ioc                #
        sw      $27,   20($26)                  # interrupt_vector[5] <= _isr_ioc
        la      $27,    _isr_dma                # 
        sw      $27,   24($26)             	# interrupt_vector[6] <= _isr_dma   

# initializes ICU
        la      $26,    seg_icu_base
        li      $27,    0x63                    # IRQ_IN[0] IRQ_IN[1] IRQ[5] IRQ[6]
        sw      $27,    8($26)                  # ICU_MASK_SET 

# initializes SR register
       	li	$26,	0x0000FF13		# Interrupt enabled
       	mtc0	$26,	$12			# SR <= 0xFF13

# jump to main in user mode
	la	$26,	main
	mtc0	$26,	$14
	eret

	.align 2

	.end	reset
	.size	reset, .-reset

	.set reorder
