
/******************************************************************************/
/* Definition of the base addresses for all vsegs used by the GIET_VM         */
/******************************************************************************/

INCLUDE giet_vsegs.ld

/******************************************************************************/
/* Grouping sections into virtual segments for system code and data           */
/******************************************************************************/

SECTIONS
{
    . = kernel_code_vbase;
    seg_kernel_code : 
    {
        *(.giet)
        *(.text)
    }

    . = kernel_data_vbase;
    seg_kernel_data : 
    {
        *(.iommu)
        *(.fatdata)
        *(.descriptor)
        *(.kdata)
        *(.rodata)
        *(.rodata.*)
        *(.data)
        *(.lit8)
        *(.lit4)
        *(.sdata)
        *(.bss)
        *(COMMON)
        *(.sbss)
        *(.scommon)
    }

    . = kernel_uncdata_vbase;
    seg_kernel_uncdata : 
    {
        *(.unckdata)
    }

    . = kernel_init_vbase;
    seg_kernel_init : 
    {
        *(.kinit)
    }
}

