///////////////////////////////////////////////////////////////////////////////////
// File     : mwr_driver.c
// Date     : 23/05/2013
// Author   : alain greiner
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////
// The mwmr_driver.c and mwmr_driver.h files are part ot the GIET-VM nano-kernel.
// This driver supports the SoClib vci_mwmr_controller component.
// 
// This peripheral can be replicated (at most one component per cluster).
//
// The (virtual) base address of the associated segment is:
//       SEG_MWR_BASE + cluster_xy * PERI_CLUSTER_INCREMENT
//
// SEG_MWR_BASE and PERI_CLUSTER_INCREMENT must be defined in hard_config.h
////////////////////////////////////////////////////////////////////////////////

#include <giet_config.h>
#include <hard_config.h>
#include <mwr_driver.h>
#include <utils.h>

#if !defined(X_SIZE) 
# error: You must define X_SIZE in the hard_config.h file
#endif

#if !defined(Y_SIZE) 
# error: You must define X_SIZE in the hard_config.h file
#endif

#if !defined(X_WIDTH) 
# error: You must define X_WIDTH in the hard_config.h file
#endif

#if !defined(Y_WIDTH) 
# error: You must define X_WIDTH in the hard_config.h file
#endif

#if !defined(SEG_MWR_BASE)
# error: You must define SEG_MWR_BASE in the hard_config.h file
#endif

#if !defined(PERI_CLUSTER_INCREMENT) 
# error: You must define PERI_CLUSTER_INCREMENT in the hard_config.h file
#endif

//////////////////////////////////////////////////////////////////////////////////
//    _mwr_hw_init()
// This function initializes one MWMR controller channel (i.e. one coprocessor
// port) in a given cluster.
// - cluster_xy    : cluster index
// _ port_id       : port index
// - way           : direction (to_coproc/from_coproc)
// - channel_pbase : physical base address of the MWMR channel 
// TODO : The MWMR controler should be modified to support 40 bits addresses...
//        Introduce a MWMR_CONFIG_PADDR_EXT register in the MWMR coprocessor
//////////////////////////////////////////////////////////////////////////////////
// Returns 0 if success, returns > 0 if error.
//////////////////////////////////////////////////////////////////////////////////
unsigned int _mwr_hw_init( unsigned int           cluster_xy, 
                           unsigned int           port_id, 
                           unsigned int           from_coproc,
                           paddr_t                channel_pbase ) 
{
    _printf(" [GIET_ERROR] _mwr_hw_init() function not supported yet\n");
    _exit();

/*
    // parameters checking 
    unsigned int x = cluster_xy >> Y_WIDTH;
    unsigned int y = cluster_xy & ((1<<Y_WIDTH)-1);
    if (x >= X_SIZE)                    return 1; 
    if (y >= Y_SIZE)                    return 1; 

    // compute base address
    unsigned int* mwr_address = (unsigned int*) ( SEG_MWR_BASE + 
                                 (cluster_xy * PERI_CLUSTER_INCREMENT) );

    unsigned int lsb = (unsigned int)channel_pbase;
    unsigned int msb = (unsigned int)(channel_pbase>>32);

    // get depth and width from channel itself
    unsigned int depth = _physical_read( channel_pbase + 16 );
    unsigned int width = _physical_read( channel_pbase + 20 );

    // initializes and launches mwmr controler
    mwr_address[port_id * MWMR_SPAN + MWMR_CONFIG_FIFO_WAY]  = from_coproc;
    mwr_address[port_id * MWMR_SPAN + MWMR_CONFIG_FIFO_NO]   = port_id;
    mwr_address[port_id * MWMR_SPAN + MWMR_CONFIG_WIDTH]     = width;
    mwr_address[port_id * MWMR_SPAN + MWMR_CONFIG_DEPTH]     = depth;
    mwr_address[port_id * MWMR_SPAN + MWMR_CONFIG_STATUS]    = lsb;
    mwr_address[port_id * MWMR_SPAN + MWMR_CONFIG_DATA]      = lsb + 24;
    mwr_address[port_id * MWMR_SPAN + MWMR_CONFIG_EXT]       = msb;
    mwr_address[port_id * MWMR_SPAN + MWMR_CONFIG_RUNNING]   = 1;
*/
    return 0;
}


// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

