///////////////////////////////////////////////////////////////////////////////////
// File     : sim_driver.c
// Date     : 23/11/2013
// Author   : alain greiner / cesar fuguet
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////
// The sim_driver.c and sim_driver.h files are part ot the GIET-VM nano-kernel.
// This driver supports the vci_sim_helper component.
// There is at most one such component in the architecture.
//
// The SEG_SIM_BASE address must be defined in the hard_config.h file.
////////////////////////////////////////////////////////////////////////////////

#include <hard_config.h>
#include <giet_config.h>
#include <sim_driver.h>

#if !defined(SEG_SIM_BASE) 
# error: You must define SEG_SIM_BASE in the hard_config.h file
#endif

////////////////////////////////////////////////////////////////////////////////
// _sim_helper_access()
// Accesses the Simulation Helper Component.
//
// If the access is on a writable register (except SIMHELPER_PAUSE_SIM),
// the simulation will stop.
// If the access is on a readable register, value is written in retval buffer.
// Returns 0 on success, 1 on failure.
////////////////////////////////////////////////////////////////////////////////
unsigned int _sim_helper_access( unsigned int register_index,
                                 unsigned int value,
                                 unsigned int * retval) 
{
    volatile unsigned int* sim_helper_address = (unsigned int*)&seg_sim_base;
    
    if (register_index == SIMHELPER_SC_STOP         ||
        register_index == SIMHELPER_END_WITH_RETVAL ||
        register_index == SIMHELPER_EXCEPT_WITH_VAL ||
        register_index == SIMHELPER_PAUSE_SIM       ||
        register_index == SIMHELPER_SIGINT) 
    {
        sim_helper_address[register_index] = value;
        return 0;
    }
    else if (register_index == SIMHELPER_CYCLES) 
    {
        *retval = sim_helper_address[register_index];
        return 0;
    }
    else 
    {
        _tty_get_lock( 0 );
        _puts("\n[GIET ERROR] in _sim_helper_access() : access to unmapped register\n");
        _tty_release_lock( 0 );
        return 1;
    }
}

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

