///////////////////////////////////////////////////////////////////////////////////
// File     : tty_driver.h
// Date     : 01/11/2013
// Author   : alain greiner
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////

#ifndef _GIET_TTY_DRIVERS_H_
#define _GIET_TTY_DRIVERS_H_

#include "utils.h"

///////////////////////////////////////////////////////////////////////////////////
// TTY (vci_multi_tty) registers offsets
///////////////////////////////////////////////////////////////////////////////////

enum TTY_registers 
{
    TTY_WRITE   = 0,
    TTY_STATUS  = 1,
    TTY_READ    = 2,
    TTY_CONFIG  = 3,
    /**/
    TTY_SPAN    = 4,
};

///////////////////////////////////////////////////////////////////////////////////
// TTY variables
///////////////////////////////////////////////////////////////////////////////////

extern volatile unsigned int _tty_rx_buf[];

extern volatile unsigned int _tty_rx_full[];

extern giet_lock_t _tty_lock[];

//////////////////////////////////////////////////////////////////////////////////
// TTY access functions
//////////////////////////////////////////////////////////////////////////////////

extern unsigned int _tty_write( const char*  buffer,
                                unsigned int length,     
                                unsigned int channel );  

extern unsigned int _tty_read(  char*        buffer,
                                unsigned int length,  
                                unsigned int channel ); 

extern void _tty_get_lock( unsigned int  channel, 
                           unsigned int* save_sr_ptr );

extern void _tty_release_lock( unsigned int  channel,
                               unsigned int* save_sr_ptr );

extern void _tty_rx_isr( unsigned int irq_type,
                         unsigned int irq_id,
                         unsigned int channel );

extern void _tty_tx_isr( unsigned int irq_type,
                         unsigned int irq_id,
                         unsigned int channel );

///////////////////////////////////////////////////////////////////////////////////
// low-level access functions
///////////////////////////////////////////////////////////////////////////////////

extern unsigned int _tty_get_register( unsigned int channel,
                                       unsigned int index );

extern void _tty_set_register( unsigned int channel,
                               unsigned int index,
                               unsigned int value );

#endif

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

