//////////////////////////////////////////////////////////////////////////////////
// File     : stdlib.c 
// Date     : 05/12/2013
// Author   : Clément DEVIGNE
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////

#include <stdlib.h>

///////////////////////////////////////////////////////////////////////////////////
// int atoi ( char * str )
///////////////////////////////////////////////////////////////////////////////////
        
int atoi(char *str)
{
    int res  = 0; // Initialize result
    int sign = 1; // Initialize sign as positive
    int i    = 0; // Initialize index of first digit

    if (str[0] == '-') //If number is negative, then update sign
    {
        sign = -1;  
        i++;           // Also update index of first digit
    }

    for (; str[i] != '\0'; ++i) // Iterate through all digits and update the result
    {
        res = res*10 + str[i] - '0';
    }

    // Return result with sign
    return sign*res;
}
        
////////////////////////////////////////////////////////////////////////////////////////
//  mempcy()
// GCC requires this function. Taken from MutekH.
////////////////////////////////////////////////////////////////////////////////////////
void * memcpy(void *_dst, const void * _src, unsigned int size) 
{
    unsigned int * dst = _dst;
    const unsigned int * src = _src;
    if (!((unsigned int) dst & 3) && !((unsigned int) src & 3) )
    {
        while (size > 3) 
        {
            *dst++ = *src++;
            size -= 4;
        }
    }

    unsigned char *cdst = (unsigned char*)dst;
    unsigned char *csrc = (unsigned char*)src;

    while (size--) 
    {
        *cdst++ = *csrc++;
    }
    return _dst;
}


////////////////////////////////////////////////////////////////////////////////////////
//  memset()
// GCC requires this function. Taken from MutekH.
////////////////////////////////////////////////////////////////////////////////////////
inline void * memset(void * dst, int s, unsigned int count) 
{
    char * a = (char *) dst;
    while (count--)
    {
        *a++ = (char)s;
    }
    return dst;
}

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4
