//////////////////////////////////////////////////////////////////////////////////
// File     : spin_lock.h         
// Date     : 01/04/2012
// Author   : alain greiner
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////
// The spin_lock.c and spin_lock.h files are part of the GIET-VM nano-kernel.
// This  library implements a user-level lock.
// It is a simple binary lock, without waiting queue.
// The lock_acquire() and lock_release() functions do not require a system call.
// If the platform does not provide hardware cache coherence, the lock must be 
// declared in a non cacheable segment,
//
// When a lock is defined in the mapping, it has not to be declared in the
// application code: it will be initialised in the boot phase,
// and the vobj_get_vbase() system call (defined in stdio.c and stdio.h files)
// can be used to get the virtual base address of the lock from it's name.
///////////////////////////////////////////////////////////////////////////////////

#ifndef _GIET_SPIN_LOCK_H_
#define _GIET_SPIN_LOCK_H_

///////////////////////////////////////////////////////////////////////////////////
//  lock structure
///////////////////////////////////////////////////////////////////////////////////

typedef struct giet_lock_s 
{
    char name[60];      // lock name
    unsigned int value; // taken if value != 0
} giet_lock_t;

//////////////////////////////////////////////////////////////////////////////
//  access functions
//////////////////////////////////////////////////////////////////////////////

extern void lock_acquire(giet_lock_t * lock);
extern void lock_release(giet_lock_t * lock);

#endif

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

