//////////////////////////////////////////////////////////////////////////////////
// File     : remote_malloc.h         
// Date     : 01/08/2014
// Author   : alain greiner
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////
// The remote_malloc.c and remote_malloc.h files are part of the GIET nano-kernel.
// These files define a very simple user-level memory allocator:
// - There is no free() : an allocated memory block is never released.
// - For each vspace, it can exist one heap[(x,y) per cluster, and the user
//   can explicitely select the target cluster(x,y).
// - Each heap(x,y) must be declared as a specific vobj in the mapping.
// - There is no constraint on the requested block size as long as it fit
//   in the selected heap.
// - For each requested block, the user can specify an alignment constraint.
///////////////////////////////////////////////////////////////////////////////////
// IMPLEMENTATION NOTE
// As the distributed heap(x,y) are global variables that can be accessed 
// concurrently by all tasks of a given vspace, each heap(x,y) is protected
// by a specific lock (defined in remote_malloc.c file. 
///////////////////////////////////////////////////////////////////////////////////

#ifndef _REMOTE_MALLOC_H
#define _REMOTE_MALLOC_H

///////////////////////////////////////////////////////////////////////////////////
// This function returne the virtual base address of the allocated block.
// - length is the block length (number of bytes).
// - align is the alignment constrain (vbase multiple of Ox1 << align).
// - If (x < X_SIZE) and (y < Y_SIZE), it uses the heap in cluster(x,y).
// - It uses the heap in cluster running the calling task, if x or y are too large.
// The calling task exit with an error message if the request cannot be satisfied.
///////////////////////////////////////////////////////////////////////////////////
extern void* remote_malloc( unsigned int length,
                            unsigned int align,
                            unsigned int x,
                            unsigned int y );

#endif


// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4



