/********************************************************************************/
/*	File : giet_config.h                                                        */
/*	Author : Alain Greiner                                                      */
/*	Date : 26/03/2013                                                           */
/********************************************************************************/
/* 	Define various configuration parameters for the GIET			            */
/********************************************************************************/

#ifndef _GIET_VM_CONFIG_H
#define _GIET_VM_CONFIG_H

/* hardware parameters */
#include "hard_config.h"

/* Debug parameters */

#define BOOT_DEBUG_MAPPING       0          /* trace map_info checking */
#define BOOT_DEBUG_PT            0          /* trace page tables initialisation */
#define BOOT_DEBUG_VOBJS         0          /* trace vobjs initialisation */
#define BOOT_DEBUG_SCHED         0          /* trace schedulers initialisation */
#define BOOT_DEBUG_PERI          0          /* trace peripherals initialisation */
#define BOOT_DEBUG_ELF           0          /* trace .elf files loading */

#define GIET_DEBUG_INIT          0          /* trace kernel initialisation */

#define GIET_DEBUG_FAT           0          /* trace fat accesses */ 
#define GIET_DEBUG_SWITCH        0          /* trace context switchs  */
#define GIET_DEBUG_IRQS          0          /* trace interrupts */
#define GIET_DEBUG_IOC_DRIVER    0          /* trace IOC accesses */
#define GIET_DEBUG_TTY_DRIVER    0          /* trace TTY accesses */
#define GIET_DEBUG_DMA_DRIVER    0          /* trace DMA accesses */
#define GIET_DEBUG_FBF_DRIVER    0          /* trace FBF accesses */
#define GIET_DEBUG_MALLOC        0          /* trace remote_malloc library */
#define GIET_DEBUG_SBT           0          /* trace SBT barrier library */

#define CONFIG_SRL_VERBOSITY TRACE 

/* software parameters */

#define GIET_ELF_BUFFER_SIZE     0x60000    /* buffer for .elf files in seg_boot_data */
#define GIET_IDLE_TASK_PERIOD    0x10000000 /* Idle Task message period */
#define GIET_OPEN_FILES_MAX      16         /* max simultaneously open files */
#define GIET_NB_VSPACE_MAX       16         /* max number of virtual spaces */
#define GIET_TICK_VALUE	         0x00100000 /* context switch period (number of cycles) */
#define GIET_USE_IOMMU           0          /* IOMMU activated when non zero */
#define GIET_NO_HARD_CC          0          /* No hard cache coherence when non zero */

#endif

