///////////////////////////////////////////////////////////////////////////////////
// File      : rdk_driver.h
// Date      : 13/02/2014
// Author    : alain greiner
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////
// The rdk_driver.c and rdk_driver.h files are part ot the GIET-VM kernel.
//
// This driver supports a virtual disk implemented as a memory segment, 
// in the physical address space. 
//
// The _rdk_read() and _rdk_write() blocking functions use a software memcpy,
// whatever the selected mode. They return only when the transfer is completed.
// As the number of concurrent accesses is not bounded, these functions
// don't use the _ioc_lock variable.
//
// The SEG_RDK_BASE virtual address must be defined in the hard_config.h
// file when the USE_RAMDISK flag is set.
///////////////////////////////////////////////////////////////////////////////////

#ifndef _GIET_RDK_DRIVERS_H_
#define _GIET_RDK_DRIVERS_H_

///////////////////////////////////////////////////////////////////////////////////
// BDV access functions and variables (vci_block_device)
///////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// This function does nothing, but is required by the IOC API.
///////////////////////////////////////////////////////////////////////////////
extern unsigned int _rdk_init();

///////////////////////////////////////////////////////////////////////////////
// Transfer data from a memory buffer to the RAMDISK. 
// - mode     : BOOT / KERNEL / USER (unused)
// - lba      : first block index on the block device
// - buffer   : virtual base address of the memory buffer
// - count    : number of blocks to be transfered.
// Returns 0 if success, > 0 if error.
///////////////////////////////////////////////////////////////////////////////
extern unsigned int _rdk_write( unsigned int lba, 
                                unsigned int buffer, 
                                unsigned int count );

///////////////////////////////////////////////////////////////////////////////
// Transfer data from the RAMDISK to a memory buffer. 
// - mode     : BOOT / KERNEL / USER (unused)
// - lba      : first block index on the block device
// - buffer   : virtual base address of the memory buffer
// - count    : number of blocks to be transfered.
// Returns 0 if success, > 0 if error.
///////////////////////////////////////////////////////////////////////////////
extern unsigned int _rdk_read(  unsigned int lba, 
                                unsigned int buffer,
                                unsigned int count );

///////////////////////////////////////////////////////////////////////////////
// This function returns the block size.
///////////////////////////////////////////////////////////////////////////////
extern unsigned int _rdk_get_block_size();

///////////////////////////////////////////////////////////////////////////////////
// This function returns always 0, but is required by the IOC API.
///////////////////////////////////////////////////////////////////////////////
extern unsigned int _rdk_get_status();

#endif

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

