///////////////////////////////////////////////////////////////////////////////////
// File     : cma_driver.h
// Date     : 01/11/2013
// Author   : alain greiner
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////
// The cma_driver.c and cma_driver.h files are part ot the GIET-VM kernel.
// This driver supports the SocLib vci_chbuf_dma component, that is
// a multi channels, chained buffer DMA controller.
//
// This component can be used in conjonction with the SocLib vci_frame_buffer 
// to display images, or with the SocLib vci_multi_nic controller to tranfer
// RX or TX packets between NIC and memory buffers.
//
// The SEG_CMA_BASE address must be defined in the hard_config.h file
//
// All accesses to CMA registers are done by the two _cma_set_register() 
// and _cma_get_register() low-level functions, that are handling virtual 
// to physical extended addressing.
//
// The higher level access functions are defined in the fbf_driver 
// and nic_driver files.
///////////////////////////////////////////////////////////////////////////////////

#ifndef _GIET_CMA_DRIVERS_H_
#define _GIET_CMA_DRIVERS_H_

///////////////////////////////////////////////////////////////////////////////////
//  registers offsets
///////////////////////////////////////////////////////////////////////////////////

enum CMA_registers 
{
    CHBUF_RUN           = 0,    // write-only : channel activated
    CHBUF_STATUS        = 1,    // read-only  : channel fsm state
    CHBUF_SRC_DESC      = 2,    // read/write : source chbuf : descriptor base address
    CHBUF_DST_DESC      = 3,    // read/write : destination chbuf : descriptor base address,
    CHBUF_SRC_NBUFS     = 4,    // read/write : source chbuf : number of buffers,
    CHBUF_DST_NBUFS     = 5,    // read/write : destination chbuf : number of buffers,
    CHBUF_BUF_SIZE      = 6,    // read/write : buffer size for both source & destination  
    CHBUF_PERIOD        = 7,    // read/write : period for status polling 
    CHBUF_SRC_EXT       = 8,    // read/write : source chbuf : descriptor base address
    CHBUF_DST_EXT       = 9,    // read/write : destination chbuf : descriptor base address,
    /****/
    CHBUF_CHANNEL_SPAN	= 1024,
};

///////////////////////////////////////////////////////////////////////////////////
//    access functions
///////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////
extern unsigned int _cma_get_register( unsigned int channel,
                                       unsigned int index );

///////////////////////////////////////////////////
extern void _cma_set_register( unsigned int channel,
                               unsigned int index,
                               unsigned int value );

///////////////////////////////////////////////////
void _cma_start_channel( unsigned int       channel,
                         unsigned long long src_paddr,
                         unsigned int       src_nbufs,
                         unsigned long long dst_paddr,
                         unsigned int       dst_nbufs,
                         unsigned int       buf_length );

//////////////////////////////////////////////
void _cma_stop_channel( unsigned int channel );

////////////////////////////////////////////
extern void _cma_isr( unsigned int irq_type,
                      unsigned int irq_id,
                      unsigned int channel );

#endif

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

