///////////////////////////////////////////////////////////////////////////////////
// File     : locks.h
// Date     : 01/12/2014
// Author   : alain greiner
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////
// The locks.c and locks.h files are part of the GIET-VM nano-kernel.
// They define both atomic increment operations and locks.
// The locks used gy the GIET_VM are spin-locks with a waiting queue.
///////////////////////////////////////////////////////////////////////////////////

#ifndef GIET_LOCKS_H
#define GIET_LOCKS_H

///////////////////////////////////////////////////////////////////////////////////
// This structure implements a spin-lock with waiting file.
// There is at most one lock per cache line.
///////////////////////////////////////////////////////////////////////////////////

typedef struct spin_lock_s 
{
    unsigned int current;        // current slot index
    unsigned int free;           // next free slot index
    unsigned int padding[14];    // for 64 bytes alignment
} spin_lock_t;

typedef struct simple_lock_s
{
    unsigned int value;
    unsigned int padding[15];
} simple_lock_t;

///////////////////////////////////////////////////////////////////////////////////
//      Locks access functions
///////////////////////////////////////////////////////////////////////////////////

extern unsigned int _atomic_increment( unsigned int* ptr,
                                       unsigned int  increment );

extern void _lock_init( spin_lock_t* lock );

extern void _lock_acquire( spin_lock_t* lock );

extern void _lock_release( spin_lock_t* lock );

extern void _simple_lock_acquire( simple_lock_t* lock );

extern void _simple_lock_release( simple_lock_t* lock );

#endif

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

