///////////////////////////////////////////////////////////////////////////////////
// File      : rdk_driver.c
// Date      : 13/02/2014
// Author    : alain greiner
// Maintainer: cesar fuguet
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////

#include <giet_config.h>
#include <hard_config.h>
#include <rdk_driver.h>
#include <utils.h>
#include <tty0.h>

#if !defined(SEG_RDK_BASE) 
# error: You must define SEG_RDK_BASE in the hard_config.h file
#endif

//////////////////////////////////////////////
unsigned int _rdk_init( unsigned int channel )
{
    return 0;
}

//////////////////////////////////////////
unsigned int _rdk_read( unsigned int lba, 
                        unsigned int buffer, 
                        unsigned int count) 
{
#if USE_IOC_RDK

#if GIET_DEBUG_IOC_DRIVER
_puts("\n[IOC DEBUG] Enter _rdk_read() at cycle ");
_putd( _get_proctime() );
_puts("\n - vaddr   = "); 
_putx( buffer );
-puts("\n - sectors = "); 
_putd( count );
-puts("\n - lba     = "); 
_putx( lba );
_puts("\n");
#endif

    char* src = (char*)SEG_RDK_BASE + (512*lba);
    char* dst = (char*)buffer;
    memcpy( dst, src, count*512 );
    return 0;

#else

    _puts("[GIET ERROR] _rdk_read() should not be used if USE_IOC_RDK not set\n");
    return 1;

#endif
}

//////////////////////////////////////////
unsigned int _rdk_write( unsigned int lba, 
                         unsigned int buffer, 
                         unsigned int count ) 
{
#if USE_IOC_RDK

#if GIET_DEBUG_IOC_DRIVER
_puts("\n[IOC DEBUG] Enter _rdk_write() at cycle ");
_putd( _get_proctime() );
_puts("\n - vaddr   = "); 
_putx( buffer );
-puts("\n - sectors = "); 
_putd( count );
-puts("\n - lba     = "); 
_putx( lba );
_puts("\n");
#endif

    char* dst = (char*)SEG_RDK_BASE + (512*lba);
    char* src = (char*)buffer;
    memcpy( dst, src, count*512 );
    return 0;

#else

    _puts("[GIET ERROR] _rdk_write() should not be used if USE_IOC_RDK not set\n");
    return 1;

#endif
}

//////////////////////////////////
unsigned int _rdk_get_block_size() 
{
    return 512;
}

//////////////////////////////
unsigned int _rdk_get_status() 
{
    return 0;
}


// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

