/****************************************************************************
* Definition of the base address for all virtual segments
*****************************************************************************/

seg_code_base        = 0x10000000;

seg_data_0_0_base    = 0x20000000;
seg_data_0_1_base    = 0x20010000;
seg_data_0_2_base    = 0x20020000;
seg_data_0_3_base    = 0x20030000;

seg_data_1_0_base    = 0x20040000;
seg_data_1_1_base    = 0x20050000;
seg_data_1_2_base    = 0x20060000;
seg_data_1_3_base    = 0x20070000;

seg_data_2_0_base    = 0x20080000;
seg_data_2_1_base    = 0x20090000;
seg_data_2_2_base    = 0x200A0000;
seg_data_2_3_base    = 0x200B0000;

seg_data_3_0_base    = 0x200C0000;
seg_data_3_1_base    = 0x200D0000;
seg_data_3_2_base    = 0x200E0000;
seg_data_3_3_base    = 0x200F0000;

/***************************************************************************
* Grouping sections into segments for code and data
***************************************************************************/

SECTIONS
{
    . = seg_code_base;
    seg_code : 
    {
        *(.text)
    }

    . = seg_data_0_0_base;
    seg_data_0_0 : 
    {
        *(.ctors)
        *(.rodata)
        *(.rodata.*)
        *(.data)
        *(.lit8)
        *(.lit4)
        *(.sdata)
        *(.bss)
        *(COMMON)
        *(.sbss)
        *(.scommon)
        *(.data_0_0)
    }
    . = seg_data_0_1_base;
    seg_data_0_1 : 
    {
        *(.data_0_1)
    }
    . = seg_data_0_2_base;
    seg_data_0_2 : 
    {
        *(.data_0_2)
    }
    . = seg_data_0_3_base;
    seg_data_0_3 : 
    {
        *(.data_0_3)
    }

    . = seg_data_1_0_base;
    seg_data_1_0 : 
    {
        *(.data_1_0)
    }
    . = seg_data_1_1_base;
    seg_data_1_1 : 
    {
        *(.data_1_1)
    }
    . = seg_data_1_2_base;
    seg_data_1_2 : 
    {
        *(.data_1_2)
    }
    . = seg_data_1_3_base;
    seg_data_1_3 : 
    {
        *(.data_1_3)
    }

    . = seg_data_2_0_base;
    seg_data_2_0 : 
    {
        *(.data_2_0)
    }
    . = seg_data_2_1_base;
    seg_data_2_1 : 
    {
        *(.data_2_1)
    }
    . = seg_data_2_2_base;
    seg_data_2_2 : 
    {
        *(.data_2_2)
    }
    . = seg_data_2_3_base;
    seg_data_2_3 : 
    {
        *(.data_2_3)
    }

    . = seg_data_3_0_base;
    seg_data_3_0 : 
    {
        *(.data_3_0)
    }
    . = seg_data_3_1_base;
    seg_data_3_1 : 
    {
        *(.data_3_1)
    }
    . = seg_data_3_2_base;
    seg_data_3_2 : 
    {
        *(.data_3_2)
    }
    . = seg_data_3_3_base;
    seg_data_3_3 : 
    {
        *(.data_3_3)
    }
}

