///////////////////////////////////////////////////////////////////////////////////
// File     : mmc_driver.h
// Date     : 01/11/2013
// Author   : alain greiner
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////

#ifndef _GIET_MMC_DRIVERS_H_
#define _GIET_MMC_DRIVERS_H_

#include <hard_config.h>
#include <locks.h>

///////////////////////////////////////////////////////////////////////////////////
// TSAR Memory Cache configuration registers offsets and commands
///////////////////////////////////////////////////////////////////////////////////

enum SoclibMemCacheConfigRegs
{
    MEMC_ADDR_LO,
    MEMC_ADDR_HI,
    MEMC_BUF_LENGTH,
    MEMC_CMD_TYPE
};

enum SoclibMemCacheConfigCmd
{
    MEMC_CMD_NOP,
    MEMC_CMD_INVAL,
    MEMC_CMD_SYNC
};

#define MMC_REG(func,idx) ((func<<7)|idx) 

///////////////////////////////////////////////////////////////////////////////
// Distributed locks protecting MMC components (one per cluster)
///////////////////////////////////////////////////////////////////////////////

spin_lock_t  _mmc_lock[X_SIZE][Y_SIZE]  __attribute__((aligned(64)));

///////////////////////////////////////////////////////////////////////////////////
// MEMC access functions (for TSAR architecture)
///////////////////////////////////////////////////////////////////////////////////

extern void _mmc_inval( unsigned long long buf_paddr, 
                        unsigned int buf_length );

extern void _mmc_sync(  unsigned long long buf_paddr, 
                        unsigned int buf_length);

extern void _mmc_isr( unsigned int irq_type,
                      unsigned int irq_id,
                      unsigned int channel );

///////////////////////////////////////////////////////////////////////////////////

#endif

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

