///////////////////////////////////////////////////////////////////////////////////
// File     : io.h
// Date     : 05/09/2012
// Author   : cesar fuguet
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////
// Utility functions to write or read memory mapped hardware registers
// The main service provided by those functions is to force an actual
// read (volatile attribute) or write (sync operation) to memory.
///////////////////////////////////////////////////////////////////////////////////

#ifndef IO_H
#define IO_H

///////////////////////////////////////////////////////////////////////////////////
// Read an 32 bits memory mapped hardware register
///////////////////////////////////////////////////////////////////////////////////
static inline unsigned int ioread32(void * addr)
{
	return *(volatile unsigned int *) addr;
}

///////////////////////////////////////////////////////////////////////////////////
// Read an 16 bits memory mapped hardware register
///////////////////////////////////////////////////////////////////////////////////
static inline unsigned short ioread16(void * addr)
{
	return *(volatile unsigned short *) addr;
}

///////////////////////////////////////////////////////////////////////////////////
// Read an 8 bits memory mapped hardware register
///////////////////////////////////////////////////////////////////////////////////
static inline unsigned char ioread8(void * addr)
{
	return *(volatile unsigned char *) addr;
}

///////////////////////////////////////////////////////////////////////////////////
// Write an 32 bits memory mapped hardware register
///////////////////////////////////////////////////////////////////////////////////
static inline void iowrite32(void * addr, unsigned int value)
{
	*(volatile unsigned int *) addr = value;
	asm volatile("sync" ::: "memory");
}

///////////////////////////////////////////////////////////////////////////////////
// Write an 16 bits memory mapped hardware register
///////////////////////////////////////////////////////////////////////////////////
static inline void iowrite16(void * addr, unsigned short value)
{
	*(volatile unsigned short *) addr = value;
	asm volatile("sync" ::: "memory");
}

///////////////////////////////////////////////////////////////////////////////////
// Write an 8 bits memory mapped hardware register
///////////////////////////////////////////////////////////////////////////////////
static inline void iowrite8(void * addr, unsigned char value)
{
	*(volatile unsigned char *) addr = value;
	asm volatile("sync" ::: "memory");
}

#undef in_reset

#endif
