#include "stdio.h"
#include "mapping_info.h"   // for coprocessors types an modes

#define  VECTOR_SIZE  32   

#define VERBOSE  1

// Memory buffers for coprocessor
unsigned int opa[VECTOR_SIZE] __attribute__((aligned(64)));
unsigned int opb[VECTOR_SIZE] __attribute__((aligned(64)));
unsigned int res[VECTOR_SIZE] __attribute__((aligned(64)));

/////////////////////////////////////////
__attribute__ ((constructor)) void main()
{
    // get processor identifiers
    unsigned int    x;
    unsigned int    y;
    unsigned int    lpid;
    giet_proc_xyp( &x, &y, &lpid );

    giet_shr_printf("\n*** Starting coproc application on processor"
                    "[%d,%d,%d] at cycle %d\n", 
                    x, y, lpid, giet_proctime() );

    // initializes opa & opb buffers
    unsigned int word;
    for ( word = 0 ; word < VECTOR_SIZE ; word++ )
    {
        opa[word] = giet_rand() + 1;
        opb[word] = giet_rand() + 1;
    }

    // request a GCD coprocessor
    unsigned int coproc_info;
    unsigned int cluster_xy;

    giet_coproc_alloc( MWR_SUBTYPE_GCD,
                       &coproc_info,
                       &cluster_xy );

    // check coprocessor ports
    unsigned int nb_to_coproc   = (coproc_info    ) & 0xFF;
    unsigned int nb_from_coproc = (coproc_info>> 8) & 0xFF;
    unsigned int nb_config      = (coproc_info>>16) & 0xFF;
    unsigned int nb_status      = (coproc_info>>24) & 0xFF;

    giet_assert( ((nb_to_coproc   == 2) &&
                  (nb_from_coproc == 1) &&
                  (nb_config      == 1) &&
                  (nb_status      == 0) ) ,
                  "wrong GCD coprocessor interface" );

    if ( VERBOSE )
    giet_shr_printf("\n*** get GCD coprocessor at cycle %d\n",
                    giet_proctime() );

    // initializes communication channels
    giet_coproc_channel_t desc;

    desc.channel_mode = MODE_DMA_NO_IRQ;
    desc.buffer_size  = VECTOR_SIZE<<2;
    desc.buffer_vaddr = (unsigned int)opa;

    giet_coproc_channel_init( cluster_xy , 0 , &desc );
    
    desc.channel_mode = MODE_DMA_NO_IRQ;
    desc.buffer_size  = VECTOR_SIZE<<2;
    desc.buffer_vaddr = (unsigned int)opb;

    giet_coproc_channel_init( cluster_xy , 1 , &desc );
    
    desc.channel_mode = MODE_DMA_IRQ;
    desc.buffer_size  = VECTOR_SIZE<<2;
    desc.buffer_vaddr = (unsigned int)res;

    giet_coproc_channel_init( cluster_xy , 2 , &desc );
    
    if ( VERBOSE )
    giet_shr_printf("\n*** initialise coomunication channels at cycle %d\n",
                    giet_proctime() );

    // starts communication channels
    giet_coproc_channel_start( cluster_xy , 0 );
    giet_coproc_channel_start( cluster_xy , 1 );
    giet_coproc_channel_start( cluster_xy , 2 );

    if ( VERBOSE )
    giet_shr_printf("\n*** start communication channels at cycle %d\n",
                    giet_proctime() );

    // starts GCD coprocessor
    giet_coproc_register_set( cluster_xy , 0 , 1 );

    if ( VERBOSE )
    giet_shr_printf("\n*** start GCD coprocessor at cycle %d\n",
                    giet_proctime() );

    // wait coprocessor completion
    giet_coproc_completed( cluster_xy );

    if ( VERBOSE )
    giet_shr_printf("\n*** GCD computation completed at cycle %d\n",
                    giet_proctime() );

    // display result
    for ( word = 0 ; word < VECTOR_SIZE ; word++ )
    {
        giet_shr_printf("pgcd( %d , %d ) = %d\n",
        opa[word] , opb[word] , res[word] );
    }

    giet_exit("completed");

} // end main

