#################################################################################
#   File : reset.s
#   Author : Alain Greiner
#   Date : 15/09/2010
#################################################################################
#   This is a boot code for a multi-processor architecture supporting
#   up to 8 processors :
#   - It initializes the Status Register (SR)
#   - It initializes the 8 stack pointers (stack size = 64K)
#   - It initializes the interrupt vector with two ISR addresses.
#   - It configurates the ICU : IRQ_IN[0] & IRQ_IN[1] activated.
#   - It initializes the EPC register, and jumps to the main in user mode.
#################################################################################

    .section .reset,"ax",@progbits

    .extern seg_stack_base
    .extern seg_data_base
    .extern main
    .extern _interrupt_vector
    .extern _isr_tty_get_task0
    .extern _isr_switch

    .globl  reset               # makes reset an external symbol
    .ent    reset
    .align  2

reset:
    .set noreorder

# initializes stack pointers
    mfc0    $10,    $15,    1
    andi    $10,    $10,    0xf		# $10 <= proc_id
    li      $27,    0x10000		# $27 <= 64 K
    mult    $27,    $10    
    mflo    $26            		# $26 <= proc_id*64K
    addu    $26,    $26,    $27		# $26 <= (proc_id + 1)*64K
    la      $29,    seg_stack_base      # $29 <= seg_stack_base
    addu    $29,    $29,    $26		# $29 <= seg_stack_base + (proc_id + 1)*64K

# initializes interrupt vector
    la      $26,    _interrupt_vector   # $26 <= interrupt_vector address
    la      $27,    _isr_switch         # 
    sw      $27,    0($26)              # interrupt_vector[0] <= _isr_switch
    la      $27,    _isr_tty_get_task0  # 
    sw      $27,    4($26)              # interrupt_vector[1] <= _isr_tty_get_task0
    la      $27,    _isr_tty_get_task1  #
    sw      $27,    8($26)              # interrupt_vector[2] <= _isr_tty_get_task1
    la      $27,    _isr_tty_get_task2  # 
    sw      $27,   12($26)              # interrupt_vector[3] <= _isr_tty_get_task2
    la      $27,    _isr_tty_get_task3  # 
    sw      $27,   16($26)              # interrupt_vector[4] <= _isr_tty_get_task3
    la      $27,    _isr_ioc            # 
    sw      $27,   20($26)              # interrupt_vector[5] <= _isr_ioc         
    la      $27,    _isr_dma            # 
    sw      $27,   24($26)              # interrupt_vector[6] <= _isr_dma

# initializes ICU
    li      $27,    0x100000       	# $27 <= 1M
    mult    $27,    $10
    mflo    $27                         # $27 <= proc_id*1M
    la      $26,    seg_icu_base
    addu    $26,    $26,    $27		# $26 <= seg_icu_base + proc_id*1M
    li      $27,    0x3             	# IRQ_IN[0] & IRQ_IN[1] enabled
    sw      $27,    8($26)          	# ICU_MASK_SET 0x3

# initializes SR register
    li      $26,    0x0000FF13      	# IRQ activation
    mtc0    $26,    $12

# jump to main in user mode
    la      $26,    main
    mtc0    $26,    $14
    eret

    .end    reset
    .size   reset, .-reset

    .set reorder
