//////////////////////////////////////////////////////////////////////////////////
// File     : stdlib.h 
// Date     : 05/12/2013
// Author   : Clément DEVIGNE
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////

#ifndef _STDLIB_H
#define _STDLIB_H

////////////////////////////////////////////////////////////////////////////////////////
// This function translate a character string to a signed integer.  
// For a negative value, the first character must be a '-' (minus) character.
////////////////////////////////////////////////////////////////////////////////////////
int atoi ( const char * str );

////////////////////////////////////////////////////////////////////////////////////////
// This function translate a character string to a double.  
// For a negative value, the first character must be a '-' (minus) character.
////////////////////////////////////////////////////////////////////////////////////////
double atof ( const char * str );

////////////////////////////////////////////////////////////////////////////////////////
// This function copies size bytes from the src source buffer 
// to the dst destination buffer.
// GCC requires this function. Taken from MutekH.
////////////////////////////////////////////////////////////////////////////////////////
void* memcpy( void*         dst, 
              const void*   src, 
              unsigned int  size );

////////////////////////////////////////////////////////////////////////////////////////
// This function initializes size bytes in the dst destination buffer, 
// with the value defined by (char)s.
// GCC requires this function. Taken from MutekH.
////////////////////////////////////////////////////////////////////////////////////////
inline void* memset( void*        dst,
                     int          s, 
                     unsigned int size );

#endif

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4
