///////////////////////////////////////////////////////////////////////////////////////
// File   : main.c   (for shell application)
// Date   : february 2014
// author : Alain Greiner
///////////////////////////////////////////////////////////////////////////////////////
// This single thread application plays with files to test the FAT32.
///////////////////////////////////////////////////////////////////////////////////////

#include "stdio.h"
#include "malloc.h"

#define NLINES   256
#define NPIXELS  256

unsigned char buf[NLINES*NPIXELS];

//////////////////////////////////////////
__attribute__ ((constructor)) void main()
//////////////////////////////////////////
{
    giet_tty_alloc();

    giet_tty_printf("\n[SHELL] Enter at cycle %d\n", giet_proctime() );

    /////////////// display disk content
    giet_fat_list( "/" );
    giet_fat_list( "/misc" );
    giet_fat_list( "/home" );

    /////////////// open lena_256.raw
    int fd_lena = giet_fat_open( "/misc/lena_256.raw" , O_RDONLY );
    if (fd_lena < 0 )  
    {
        giet_exit("cannot open file lena_256.raw");
    }
    else
    {
        giet_tty_printf("\n[SHELL] open lena_256.raw\n");
    }

    /////////////// open copy.raw
    int fd_copy = giet_fat_open( "/home/copy.raw" , O_CREATE );
    if (fd_copy < 0 )
    {
        giet_exit("cannot open file copy.raw");
    }
    else
    {
        giet_tty_printf("\n[SHELL] open copy.raw\n");
    }

    //////////////// load lena_256.raw
    if ( giet_fat_lseek( fd_lena , 0 , SEEK_SET ) )
    {
        giet_exit("cannot seek lena_256.raw");
    }

    if ( giet_fat_read( fd_lena , buf , NLINES*NPIXELS ) != NLINES*NPIXELS )
    {
        giet_exit("cannot read lena_256.raw");
    }
    else
    {
        giet_tty_printf("\n[SHELL] lena_256.raw loaded from device\n");
    }

    ////////////// store copy.raw
    if ( giet_fat_lseek( fd_copy , 0 , SEEK_SET ) )
    {
        giet_exit("cannot seek copy.raw");
    }

    if ( giet_fat_write( fd_copy , buf , NLINES*NPIXELS ) != NLINES*NPIXELS )
    {
        giet_exit("cannot write copy.raw");
    }
    else
    {
        giet_tty_printf("\n[SHELL] copy.raw stored to device\n");
    }

    ///////////// close lena_256.raw
    if ( giet_fat_close( fd_lena ) )
    {
        giet_exit("cannot close lena_256.raw");
    }
    else 
    {
        giet_tty_printf("\n[SHELL] lena_256.raw closed\n");
    }

    ///////////// close copy.raw
    if ( giet_fat_close( fd_copy ) )
    {
        giet_exit("cannot close copy.raw");
    }
    else 
    {
        giet_tty_printf("\n[SHELL] copy.raw closed\n");
    }

    ////////////// display disk content
    giet_fat_list( "/" );
    giet_fat_list( "/misc" );
    giet_fat_list( "/home" );

    ///////////// rename copy.raw
    if ( giet_fat_rename( "/home/copy.raw" , "/misc/copy_lena.raw" ) )
    {
        giet_exit("cannot rename /home/copy.raw");
    }
    else 
    {
        giet_tty_printf("\n[SHELL] /home/copy.raw renamed to /misc/copy_lena.raw\n");
    }
    
    ////////////// display disk content
    giet_fat_list( "/" );
    giet_fat_list( "/misc" );
    giet_fat_list( "/home" );

    ///////////// remove home
    if ( giet_fat_remove( "/home" , 1 ) )
    {
        giet_exit("cannot remove /home");
    }
    else 
    {
        giet_tty_printf("\n[SHELL] /home removed from file system\n");
    }
    
    ////////////// display disk content
    giet_fat_list( "/" );
    giet_fat_list( "/misc" );

    //////////// create new_home 
    if ( giet_fat_mkdir( "/new_home" ) )
    {
        giet_exit("cannot create /new_home");
    }
    else 
    {
        giet_tty_printf("\n[SHELL] /new_home created in file system\n");
    }
    
    ////////////// display disk content
    giet_fat_list( "/" );
    giet_fat_list( "/misc" );
    giet_fat_list( "/new_home" );

    giet_exit("Completed");

} // end main()

// Local Variables:
// tab-width: 3
// c-basic-offset: 
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=3:tabstop=3:softtabstop=3



