////////////////////////////////////////////////////////////////////////////////
// File     : fat32_shared.h
// Date     : 27/07/2015
// Author   : Clément Guérin
// Copyright (c) UPMC-LIP6
////////////////////////////////////////////////////////////////////////////////

#ifndef _FAT32_SHARED
#define _FAT32_SHARED

/********************************************************************************
  This struct is used by _fat_file_info().
********************************************************************************/

typedef struct fat_file_info_s
{
    unsigned int size;      // size in bytes
    unsigned int offset;    // offset in bytes
    unsigned int is_dir;    // is the file a directory
}   fat_file_info_t;

/********************************************************************************
  This struct is used by _fat_readdir(). It describes a directory entry.
********************************************************************************/

typedef struct fat_dirent_s
{
    unsigned int cluster;   // cluster index
    unsigned int size;      // size in bytes
    unsigned int is_dir;    // is the entry a directory
    char name[36];          // entry name
}   fat_dirent_t;

/********************************************************************************
  _fat_open() flags.
********************************************************************************/

#define O_RDONLY                0x01
#define O_TRUNC                 0x10
#define O_CREATE                0x20

/********************************************************************************
  _fat_lseek() flags.
********************************************************************************/

#define SEEK_SET                0
#define SEEK_CUR                1

#endif // _FAT32_SHARED

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

