//////////////////////////////////////////////////////////////////////////////////
// File     : stdlib.h 
// Date     : 05/12/2013
// Author   : Clément DEVIGNE
// Copyright (c) UPMC-LIP6
///////////////////////////////////////////////////////////////////////////////////

#ifndef _STDLIB_H
#define _STDLIB_H

////////////////////////////////////////////////////////////////////////////////////////
// This function translates a character string to a signed integer.  
// For a negative value, the first character must be a '-' (minus) character.
////////////////////////////////////////////////////////////////////////////////////////
int atoi ( const char * str );

////////////////////////////////////////////////////////////////////////////////////////
// This function translate a character string to a double.  
// For a negative value, the first character must be a '-' (minus) character.
////////////////////////////////////////////////////////////////////////////////////////
double atof ( const char * str );

////////////////////////////////////////////////////////////////////////////////////////
// This function copies size bytes from the src source buffer 
// to the dst destination buffer.
// GCC requires this function. Taken from MutekH.
////////////////////////////////////////////////////////////////////////////////////////
void* memcpy( void*         dst, 
              const void*   src, 
              unsigned int  size );

////////////////////////////////////////////////////////////////////////////////////////
// This function initializes size bytes in the dst destination buffer, 
// with the value defined by (char)s.
// GCC requires this function. Taken from MutekH.
////////////////////////////////////////////////////////////////////////////////////////
void* memset( void*        dst,
              int          s,
              unsigned int size );

////////////////////////////////////////////////////////////////////////////////////////
// This function returns the number of characters in a string.
// The terminating NUL character is not taken into account.
////////////////////////////////////////////////////////////////////////////////////////
unsigned int strlen( char* string );

////////////////////////////////////////////////////////////////////////////////////////
// This function compare the two s1 & s2 strings.
// It returns 0 if strings are identical (including the terminating NUL character).
// It returns 1 if they are not. 
////////////////////////////////////////////////////////////////////////////////////////
unsigned int strcmp( char* s1,
                     char* s2 );

////////////////////////////////////////////////////////////////////////////////////////
// This function copies the source string to the dest string.
// It returns a pointer on the dest string.
////////////////////////////////////////////////////////////////////////////////////////
char* strcpy( char* dest,
              char* source );

#endif

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
// vim: filetype=c:expandtab:shiftwidth=4:tabstop=4:softtabstop=4
